<?php

namespace Modules\Common\Entities\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EntityContacts extends Model 
{

    protected $table = 'entity_contacts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contactTypes()
    {
        return $this->belongsTo('ContactType');
    }

    public function contactGroups()
    {
        return $this->belongsToMany('ContactGroup');
    }

    public function entity()
    {
        return $this->belongsTo('Entity');
    }

}